type array α (* a global definition, maybe this is optional *)


module Array = 
  let build = bee_array_build (* build doesn't initialize the array *)
  let length = bee_array_length
  let get = bee_array_get
  let set = bee_array_set
  let blit = bee_array_blit
    
  (* TODO: with make, the array should be initialized to "a" *)
  let make n a = 
    build n

  let copy a = 
    let arr = build (length a) in 
    let () = blit a 0 arr 0 (length a) in 
    arr
    
  let append a1 a2 = 
    let n1 = length a1 in 
    let n2 = length a2 in 
    let arr = build (n1 + n2) in 
    let () = blit a1 0 arr 0 n1 in 
    let () = blit a2 0 arr n1 n2 in 
    arr

  let sub a offset size = 
    if offset + size > length a then (* TODO: can be removed if rich types *)
      let () = print_string "invalid arguments in Array.sub\n" in 
      error 1
    else
      let arr = bee_array_build size in 
      let () = bee_array_blit a offset arr 0 size in 
      arr
    
  let fold f accu arr = 
    let result = ref accu in 
    let () = 
      for 0 (length arr - 1)
        (fun i -> (result := f !result arr[i])) in  (* TODO: extra parenthesis should not be needed *)
    !result
    
  let foldi f accu arr = 
    let result = ref accu in 
    let () = 
      for 0 (length arr - 1)
        (fun i -> (result := f !result i arr[i])) in  (* TODO: extra parenthesis should not be needed *)
    !result
    
  let iter f arr = 
    for 0 (length arr - 1) (fun i -> f arr[i])
    
  let iteri f arr = 
    for 0 (length arr - 1) (fun i -> f i arr[i])
    
  let map f arr = 
    let new_arr = build (length arr) in 
    let () = 
      for 0 (length arr - 1) 
         (fun i -> new_arr[i] <- f arr[i]) in 
    new_arr
    
  let find elt arr = 
    foldi (fun b i a -> if elt = a then Some i else b) None arr

endmodule
